/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.attachment.Attachment;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.internal.action.AttachmentAdd;
import de.willuhn.jameica.gui.internal.action.AttachmentDelete;
import de.willuhn.jameica.gui.internal.action.AttachmentSave;
import de.willuhn.jameica.gui.internal.action.AttachmentSettings;
import de.willuhn.jameica.gui.internal.parts.AttachmentListPart;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.util.ApplicationException;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AttachmentManageDialog
extends AbstractDialog {
    final int WINDOW_WIDTH = 720;
    final int WINDOW_HEIGHT = 400;

    public AttachmentManageDialog(int position) {
        super(position);
        this.setTitle(Application.getI18n().tr("Dateianh\u00e4nge"));
        this.setSize(720, 400);
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        SimpleContainer container = new SimpleContainer(parent, true);
        container.addText(Application.getI18n().tr("Klicken Sie doppelt auf einen Dateianhang, um diesen zu \u00f6ffnen oder mit der rechten Maustaste, um das Kontextmen\u00fc zu \u00f6ffnen."), true);
        AttachmentListPart table = new AttachmentListPart();
        ((TablePart)table).paint(container.getComposite());
        DropTarget target = new DropTarget((Control)container.getComposite(), 19);
        final FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{fileTransfer};
        target.setTransfer(types);
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                if (event.detail == 16) {
                    event.detail = (event.operations & 1) != 0 ? 1 : 0;
                }
                for (int i = 0; i < event.dataTypes.length; ++i) {
                    if (!fileTransfer.isSupportedType(event.dataTypes[i])) continue;
                    event.currentDataType = event.dataTypes[i];
                    if (event.detail == 1) break;
                    event.detail = 0;
                    break;
                }
            }

            public void drop(DropTargetEvent event) {
                if (event.data == null) {
                    event.detail = 0;
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(AttachmentManageDialog.this.i18n.tr("Fehler bem Hinzuf\u00fcgen der Datei(en)"), 1));
                    return;
                }
                try {
                    new AttachmentAdd().handleAction(event.data);
                }
                catch (ApplicationException e) {
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(AttachmentManageDialog.this.i18n.tr("Fehler bem Hinzuf\u00fcgen der Datei(en)"), 1));
                }
            }

            public void dragLeave(DropTargetEvent event) {
            }

            public void dragOperationChanged(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
            }

            public void dropAccept(DropTargetEvent event) {
            }
        });
        final Button save = new Button(Application.getI18n().tr("Speichern..."), e -> new AttachmentSave().handleAction(table.getSelection()), null, false, "document-save.png");
        save.setEnabled(false);
        final Button delete = new Button(Application.getI18n().tr("L\u00f6schen..."), e -> new AttachmentDelete().handleAction(table.getSelection()), null, false, "user-trash-full.png");
        delete.setEnabled(false);
        table.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                if (event.data == null) {
                    return;
                }
                Attachment[] selection = null;
                selection = event.data instanceof Attachment[] ? (Attachment[])event.data : new Attachment[]{(Attachment)event.data};
                save.setEnabled(selection.length >= 1);
                delete.setEnabled(selection.length >= 1);
            }
        });
        ButtonArea buttons = new ButtonArea();
        buttons.addButton(Application.getI18n().tr("Dateien hinzuf\u00fcgen..."), new AttachmentAdd(), null, false, "list-add.png");
        buttons.addButton(save);
        buttons.addButton(delete);
        buttons.addButton(Application.getI18n().tr("Einstellungen"), new AttachmentSettings(), null, false, "document-properties.png");
        buttons.addButton(Application.getI18n().tr("Schlie\u00dfen"), x -> this.close(), null, true, "window-close.png");
        container.addButtonArea(buttons);
        this.getShell().setMinimumSize(this.getShell().computeSize(720, 400));
    }

    protected Object getData() throws Exception {
        return null;
    }
}

